#include "Keyboard+EasyPOD.H"

//----- Only for Testing -----//
sbit       KEY0_PIN     =    P1^0;
sbit       KEY1_PIN     =    P1^1;
sbit       KEY2_PIN     =    P1^2;

sbit       LED0_PIN     =    P3^5;
sbit       LED1_PIN     =    P3^6;
sbit       LED2_PIN     =    P3^7;
//----- Only for Testing -----//

void USB_Event( void );


BYTE OutLen;
BYTE OutBuffer[64];


void main( void )
  { Initial();                                   // Do not remove
    while(1)
      { if ( InFlag )                            // Data size of "InLen" is already 
          { // To do..                           // in the "InBuffer[]"
                                                 // For Loop Back test
            USB_Send_Data_To_PC( InLen , InBuffer );
            
            USB_Read_Data_Complete();            // Do not remove
          }
        
        // To do..
        /* Will send data to PC ?? If yes , enable the following function call */
        
        /* In order to gain the best performance, the value of "OutLen" should be  
           the multiple of 62. ( Exp: OutLen = 62, 124, 186, and ... ) */
        // USB_Send_Data_To_PC( OutLen , OutBuffer );
        
        if ( KEY0_PIN == CLR )
          { OutLen = 1;
            OutBuffer[0] = 0x04;                 // ASCII CODE ( 'a' )
            USB_Send_Key_To_PC( L_SHIFT , OutLen , OutBuffer );
            while( KEY0_PIN == CLR );
          }
        if ( KEY1_PIN == CLR )
          { USB_Send_MediaKey_To_PC( KEY_VOLUMEUP );
            while( KEY1_PIN == CLR );
          }
        if ( KEY2_PIN == CLR )
          { OutLen = 1;
            OutBuffer[0] = 0x5A;                 // Meaningless data for testing
            USB_Send_Data_To_PC( OutLen , OutBuffer );
            while( KEY2_PIN == CLR );
          }
        
        USB_Event();                             // Check USB power event
      }   
  }


void USB_Event( void )                           // Do not remove
  { if ( UsbEvent.Suspend == SET )               // Power down event from HOST
      { UsbEvent.Suspend = CLR;
        // To do..
        PCON |= 0x02;                            // MCU will into PowerDown mode
        UsbEvent.WakeUp = SET;
      }
    if ( UsbEvent.WakeUp == SET )                // MCU wakeup already
      { UsbEvent.WakeUp = CLR;
      	// To do..
      }
    if ( UsbEvent.Reset == SET )                 // Reset event from HOST
      { UsbEvent.Reset = CLR;
        // To do..
      }
    if ( UsbEvent.EmuOK == SET )                 // USB enumeration OK
      { // To do..
      }
    if ( UsbEvent.WakeupHost == SET )            // Device self wakeup
      { UsbEvent.WakeupHost = CLR;               // This flag SET by user ISR ( KeyPad/Uart/.. )
        if ( USB_WakeUp_Host() )                 // Wakeup host successful
          { // To do..
          }
        else                                     // Wakeup host fail 
          { // To do..
          }
      }
    if ( UsbEvent.KB_LED == SET )
      { UsbEvent.KB_LED = CLR;                   // Keyboard LED change by host
      	// To do..                               // Change the LED status base on KB_LED
      	
      	if ( KB_LED & LED_NumLock )
      	  LED0_PIN = CLR;
      	else
      	  LED0_PIN = SET;
      	if ( KB_LED & LED_Caps )
      	  LED1_PIN = CLR;
      	else
      	  LED1_PIN = SET;
      	if ( KB_LED & LED_ScrollLock )
      	  LED2_PIN = CLR;
      	else
      	  LED2_PIN = SET;
      }
  }